package com.izenpe.zain.cliente.pdf;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class ActualizacionFirmaPDF_TS_XL {
	
	//Nombre del fichero cuya firma va a ser actualizada.
	private static final String fileName =  "PruebaPDFSignedTS.pdf";

	public static void main(String[] args) 
	{
		try 
		{
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT, SmartVerifyRequest.Service.DR);
				
			//Se establece el perfil No Repudio en la peticin de Actualizacin de firma.
			smartVerifyReq.setProfile(Constants.Profile.NONREP);
			
			/*
			 * Se establece el idioma de la peticin en espaol. 2 posibilidades:
			 * 	 1. Espaol: 'es'
			 * 	 2. Ingls:  'en'
			 */
			smartVerifyReq.setLanguage("es");
			
			/*
	         * Se solicita en la peticin de Actualizacin que se aadan 
	         * a la respuesta los valores de los certificados.
	         */
			smartVerifyReq.setAddCertificateValues(Constants.AddValues.SIMPLE);
			
			/*
	         * Se solicita en la peticin de Actualizacin que se aadan a la 
	         * respuesta la informacin de revocacin de los certificados.
	         */
			smartVerifyReq.setAddRevocationValues(Constants.AddValues.SIMPLE);
	        
	        /*
			 * Se solicita en la peticin de Actualizacin que se aadan los
			 * valores del Sello de Tiempo.
			 */
			smartVerifyReq.setAddTimeStampValues(Constants.AddValues.SIMPLE);
			
			
			/*
			 * Con el valor Constants.SignatureFormat.ES_A, la respuesta aadira 
			 * informacin sobre la validez del certificado. 
			 */
			smartVerifyReq.setReturnUpdatedSignature(Constants.SignatureFormat.ES_XL);
			
			//Datos a verificar.
			smartVerifyReq.setInputPdfBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/output/" + fileName)));
			
			//Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();
			
			//Se comprueba la validez de la respuesta de Actualizacin de firma PDF.
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor())) && Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor()))
			{
				String signBase64 = smartVerifyResp.getDocumentWithSignaturePdf();
				byte[] data = Base64.decode(signBase64);
				String destFilename = "data/output/" + "PruebaPDFSignedTS_XL.pdf";
				ZainUtil.writeBinaryFile(destFilename, data);
				System.out.println("La firma ha sido actualizada con xito.");
			}
			else
			{
				System.out.println("La actualizacin de la firma contiene errores: " + smartVerifyResp.getResultMessage());
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
	}
}